<?php
$host = "localhost";
$user = "root";
$pass = "";
$db = "prestiz_hotel";

$conn = new mysqli($host, $user, $pass, $db);

if ($conn->connect_error) {
    die("Błąd połączenia: " . $conn->connect_error);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];

    // Sprawdzamy czy email istnieje
    $check = $conn->prepare("SELECT * FROM customers WHERE email = ?");
    $check->bind_param("s", $email);
    $check->execute();
    $result = $check->get_result();

    if ($result->num_rows > 0) {
        $message = "Konto z tym adresem email już istnieje!";
    } else {
        $stmt = $conn->prepare("INSERT INTO customers (full_name, email, phone) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $name, $email, $phone);

        if ($stmt->execute()) {
            $message = "Rejestracja przebiegła pomyślnie! Możesz teraz dokonać rezerwacji.";
        } else {
            $message = "Błąd podczas rejestracji.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <title>Rejestracja klienta - Hotel PRESTIŻ</title>
</head>
<body>

<h2>Rejestracja w Hotelu PRESTIŻ</h2>

<form method="POST">
    Imię i nazwisko:<br>
    <input type="text" name="name" required><br><br>

    Email:<br>
    <input type="email" name="email" required><br><br>

    Telefon:<br>
    <input type="text" name="phone"><br><br>

    <button type="submit">Zarejestruj się</button>
</form>

<?php if (!empty($message)) echo "<p><strong>$message</strong></p>"; ?>

</body>
</html>
