CREATE DATABASE prestiz_hotel;
USE prestiz_hotel;

-- Tabela pokoi
CREATE TABLE rooms (
    room_id INT AUTO_INCREMENT PRIMARY KEY,
    room_number VARCHAR(10) UNIQUE NOT NULL,
    room_type ENUM('Standard', 'Luksusowy apartament', 'Prezydencki') NOT NULL,
    price DECIMAL(10,2) NOT NULL
);

-- Tabela usług
CREATE TABLE services (
    service_id INT AUTO_INCREMENT PRIMARY KEY,
    service_name VARCHAR(100) NOT NULL,
    price DECIMAL(10,2) NOT NULL
);

-- Klienci
CREATE TABLE customers (
    customer_id INT AUTO_INCREMENT PRIMARY KEY,
    full_name VARCHAR(100) NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    phone VARCHAR(20)
);

-- Rezerwacje
CREATE TABLE reservations (
    reservation_id INT AUTO_INCREMENT PRIMARY KEY,
    customer_id INT NOT NULL,
    room_id INT NOT NULL,
    check_in DATE NOT NULL,
    check_out DATE NOT NULL,
    total_cost DECIMAL(10,2),
    reservation_code VARCHAR(50) UNIQUE NOT NULL,
    FOREIGN KEY (customer_id) REFERENCES customers(customer_id),
    FOREIGN KEY (room_id) REFERENCES rooms(room_id)
);

-- Usługi dodane do rezerwacji
CREATE TABLE reservation_services (
    reservation_id INT,
    service_id INT,
    PRIMARY KEY (reservation_id, service_id),
    FOREIGN KEY (reservation_id) REFERENCES reservations(reservation_id),
    FOREIGN KEY (service_id) REFERENCES services(service_id)
);

-- Przykładowe pokoje
INSERT INTO rooms (room_number, room_type, price) VALUES
('101', 'Standard', 450.00),
('102', 'Standard', 450.00),
('201', 'Luksusowy apartament', 1200.00),
('202', 'Luksusowy apartament', 1200.00),
('301', 'Prezydencki', 3500.00),
('302', 'Prezydencki', 3500.00);

-- Usługi
INSERT INTO services (service_name, price) VALUES
('Masaż relaksacyjny', 200.00),
('Masaż premium', 350.00),
('Pakiet SPA Basic', 500.00),
('Pakiet SPA Deluxe', 1200.00);

-- Przykładowi klienci
INSERT INTO customers (full_name, email, phone) VALUES
('Jan Kowalski', 'jan@example.com', '500100200'),
('Anna Nowak', 'anna@example.com', '502111333');

-- Przykładowe rezerwacje
INSERT INTO reservations (customer_id, room_id, check_in, check_out, total_cost, reservation_code) VALUES
(1, 201, '2025-11-10', '2025-11-12', 2400.00, 'RES-AB12CD'),
(2, 301, '2025-11-15', '2025-11-16', 3500.00, 'RES-EF34GH');

INSERT INTO reservation_services (reservation_id, service_id) VALUES
(1, 2),
(1, 3),
(2, 4);
