<?php
// SINGLE FILE ADMIN PANEL FOR HOTEL PRESTIŻ (BOOTSTRAP DARK MODE)
// Merges: login, reservation list, customers list, rooms list, logout

session_start();

$host = "localhost";
$user = "root";
$pass = "";
$db = "prestiz_hotel";
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) die("Database connection error");

// LOGOUT
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: ?");
    exit;
}

// LOGIN ACTION
if (isset($_POST['username'])) {
    $username = $_POST['username'];
    $password = hash('sha256', $_POST['password']);

    $stmt = $conn->prepare("SELECT * FROM admins WHERE username=? AND password=?");
    $stmt->bind_param("ss", $username, $password);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 1) {
        $_SESSION['admin'] = $username;
    } else {
        $error = "Błędny login lub hasło";
    }
}

// LOGIN VIEW
if (!isset($_SESSION['admin'])) {
?>
<!DOCTYPE html>
<html lang="pl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Panel administratora – Hotel PRESTIŻ</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-dark text-light">
<div class="container py-5">
<form method="POST" class="w-25 mx-auto p-4 border rounded bg-secondary shadow">
<h2 class="mb-3 text-center">Panel admin – logowanie</h2>
<input type="text" name="username" class="form-control mb-3" placeholder="Login" required>
<input type="password" name="password" class="form-control mb-3" placeholder="Hasło" required>
<button type="submit" class="btn btn-warning w-100">Zaloguj</button>
<?php if (isset($error)) echo "<p class='text-danger mt-3'>$error</p>"; ?>
</form>
</div>
</body>
</html>
<?php exit; }
?>

<!DOCTYPE html>
<html lang="pl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Panel administratora – Hotel PRESTIŻ</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-dark text-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
<div class="container-fluid">
<a class="navbar-brand" href="#"><i class="bi bi-building"></i> Hotel PRESTIŻ</a>
<div class="collapse navbar-collapse justify-content-end">
<ul class="navbar-nav">
<li class="nav-item"><a class="nav-link" href="?logout"><i class="bi bi-box-arrow-right"></i> Wyloguj</a></li>
</ul>
</div>
</div>
</nav>
<div class="container">

<h3>Rezerwacje</h3>
<div class="card mb-4 bg-secondary text-light">
<div class="card-body p-0">
<table class="table table-dark table-striped table-hover mb-0">
<tr><th>ID</th><th>Klient</th><th>Pokój</th><th>Od</th><th>Do</th><th>Koszt</th><th>Kod</th></tr>
<?php
$q = $conn->query("SELECT r.*, c.full_name, rm.room_number FROM reservations r JOIN customers c ON r.customer_id=c.customer_id JOIN rooms rm ON r.room_id=rm.room_id");
while($row = $q->fetch_assoc()) echo "<tr><td>{$row['reservation_id']}</td><td>{$row['full_name']}</td><td>{$row['room_number']}</td><td>{$row['check_in']}</td><td>{$row['check_out']}</td><td>{$row['total_cost']} PLN</td><td>{$row['reservation_code']}</td></tr>";
?>
</table>
</div>
</div>

<h3>Klienci</h3>
<div class="card mb-4 bg-secondary text-light">
<div class="card-body p-0">
<table class="table table-dark table-striped table-hover mb-0">
<tr><th>ID</th><th>Imię i nazwisko</th><th>Email</th><th>Telefon</th></tr>
<?php
$q = $conn->query("SELECT * FROM customers");
while($row = $q->fetch_assoc()) echo "<tr><td>{$row['customer_id']}</td><td>{$row['full_name']}</td><td>{$row['email']}</td><td>{$row['phone']}</td></tr>";
?>
</table>
</div>
</div>

<h3>Pokoje</h3>
<div class="card mb-4 bg-secondary text-light">
<div class="card-body p-0">
<table class="table table-dark table-striped table-hover mb-0">
<tr><th>ID</th><th>Numer pokoju</th><th>Typ</th><th>Cena / noc</th></tr>
<?php
$q = $conn->query("SELECT * FROM rooms");
while($row = $q->fetch_assoc()) echo "<tr><td>{$row['room_id']}</td><td>{$row['room_number']}</td><td>{$row['room_type']}</td><td>{$row['price']} PLN</td></tr>";
?>
</table>
</div>
</div>

</div>
</body>
</html>