<?php
$host = "localhost";
$user = "root";
$pass = "";
$db = "prestiz_hotel";

$conn = new mysqli($host, $user, $pass, $db);

if ($conn->connect_error) {
    die("Błąd połączenia: " . $conn->connect_error);
}

$code = $_GET['code'] ?? '';

if ($code) {
    $sql = "
        SELECT r.reservation_code, c.full_name, c.email, rm.room_number, rm.room_type, 
               r.check_in, r.check_out, r.total_cost
        FROM reservations r
        JOIN customers c ON r.customer_id = c.customer_id
        JOIN rooms rm ON r.room_id = rm.room_id
        WHERE r.reservation_code = ?
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $code);
    $stmt->execute();
    $result = $stmt->get_result();
}
?>

<!DOCTYPE html>
<html>
<head>
<title>Sprawdzenie rezerwacji - Hotel PRESTIŻ</title>
</head>
<body>
<h2>Wyszukaj rezerwację</h2>
<form method="GET">
    Kod rezerwacji: <input type="text" name="code" required>
    <button type="submit">Sprawdź</button>
</form>

<?php if (!empty($result) && $result->num_rows > 0): ?>
    <?php $row = $result->fetch_assoc(); ?>
    <h3>Twoja rezerwacja:</h3>
    Imię i nazwisko: <?= $row['full_name']; ?><br>
    Email: <?= $row['email']; ?><br>
    Pokój: <?= $row['room_number']; ?> (<?= $row['room_type']; ?>)<br>
    Check-in: <?= $row['check_in']; ?><br>
    Check-out: <?= $row['check_out']; ?><br>
    Koszt: <?= $row['total_cost']; ?> PLN<br>

<?php elseif ($code): ?>
    <p>Brak rezerwacji o podanym kodzie.</p>
<?php endif; ?>

</body>
</html>
